clear; clc; 

WhereAreWe = cd;
path(path,[WhereAreWe '\Subroutines']);


[QuarterlyGrowth] = xlsread([WhereAreWe '\Data\SomeMacroSeries.xls'],'MACRO SERIES FRED','f4:i280');  
[~,~,AnnualGrowth] = xlsread([WhereAreWe '\Data\SomeMacroSeries.xls'],'MACRO SERIES FRED','l4:o280'); AnnualGrowth = cell2mat(AnnualGrowth); 
[~,~,DatesNum] = xlsread([WhereAreWe '\Data\SomeMacroSeries.xls'],'MACRO SERIES FRED','b4:b280'); DatesNum = cell2mat(DatesNum);


DatesStr = datestr(DatesNum);
Dates = [1947+2/4:1/4:2020]'; Dates = Dates(1:size(DatesNum,1),1);


NamesVariables{1} = 'GDP Annual Growth'; 
NamesVariables{2} = 'Consumption Annual Growth'; 
NamesVariables{3} = 'Investment Annual Growth'; 
NamesVariables{4} = 'Hours Annual Growth'; 
NamesVariables{5} = 'GDP Quarterly Growth'; 
NamesVariables{6} = 'Consumption Quarterly Growth'; 
NamesVariables{7} = 'Investment Quarterly Growth'; 
NamesVariables{8} = 'Hours Quarterly Growth'; 

%% ORGANIZE DATA
All_DATA = [AnnualGrowth QuarterlyGrowth]; 

SplittingDate = 1984+2/4;
CUT_Sample_at84 = find(Dates==SplittingDate); 
    
Quantili = [.05,.16,.84,.95]; 
PickQuantiliTable = [2,3];

%% TWO SAMPLE SPLIT AND COMPUTE STATS

TABLE_SKEWNESS_PRE = [];
TABLE_SKEWNESS_POST = [];
for jj=1:size(All_DATA,2); 
    
    %% SKEWNESS
    XX = All_DATA(1:CUT_Sample_at84,jj);
    XX = XX(isfinite(XX),1);
    
    [Skew_pre84,SD_Skew_pre84,SkewQuant_pre84]=SkewBootstrap(XX,Quantili); 
    TABLE_SKEWNESS_PRE = [TABLE_SKEWNESS_PRE; [Skew_pre84 NaN];SkewQuant_pre84(PickQuantiliTable); NaN*zeros(1,2);];
    
    [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili); 
    TABLE_SEMIVARIANCE(jj,1) = sqrt(PosSemiVar+NegSemiVar);
    TABLE_SEMIVARIANCE(jj,2) = RatioSV;
    TABLE_SEMIVARIANCE(jj,3:4) = RatioSVQuant(PickQuantiliTable);
    
    XX = All_DATA(CUT_Sample_at84+1:end,jj);
    
    [Skew_post84,SD_Skew_post84,SkewQuant_post84]=SkewBootstrap(XX,Quantili); 
    TABLE_SKEWNESS_POST = [TABLE_SKEWNESS_POST; [Skew_post84 NaN];SkewQuant_post84(PickQuantiliTable); NaN*zeros(1,2);];

    [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili); 
    TABLE_SEMIVARIANCE(jj,5) = sqrt(PosSemiVar+NegSemiVar);
    TABLE_SEMIVARIANCE(jj,6) = RatioSV;
    TABLE_SEMIVARIANCE(jj,7:8) = RatioSVQuant(PickQuantiliTable);
        
end

QUARTERLY_DATA_PRE = TABLE_SKEWNESS_PRE(size(TABLE_SKEWNESS_PRE,1)/2+1:end,:);
YEARLY_DATA_PRE = TABLE_SKEWNESS_PRE(1:size(TABLE_SKEWNESS_PRE,1)/2,:);
QUARTERLY_DATA_POST = TABLE_SKEWNESS_POST(size(TABLE_SKEWNESS_POST,1)/2+1:end,:);
YEARLY_DATA_POST = TABLE_SKEWNESS_POST(1:size(TABLE_SKEWNESS_POST,1)/2,:);
TABLE_TO_SAVE = [QUARTERLY_DATA_PRE QUARTERLY_DATA_POST NaN*QUARTERLY_DATA_POST YEARLY_DATA_PRE YEARLY_DATA_POST]; 
TABLE_TO_SAVE = round(TABLE_TO_SAVE,3);

TABLE_1 = TABLE_TO_SAVE; 
% swp2(TABLE_1,'Table_Skewness.tex');

PickOutput = [1,5];
TABLE_SEMIVARIANCE_Y = TABLE_SEMIVARIANCE(PickOutput,:);
TABLE_SemiVolRatioGDP_toShow = [[TABLE_SEMIVARIANCE_Y(1,1) NaN; TABLE_SEMIVARIANCE_Y(1,2) NaN; TABLE_SEMIVARIANCE_Y(1,[3,4])] ...
                                [TABLE_SEMIVARIANCE_Y(1,5) NaN; TABLE_SEMIVARIANCE_Y(1,6) NaN; TABLE_SEMIVARIANCE_Y(1,[7,8])]];  
TABLE_SemiVolRatioGDP_toShow = [TABLE_SemiVolRatioGDP_toShow NaN*TABLE_SemiVolRatioGDP_toShow(:,1)...
                                [[TABLE_SEMIVARIANCE_Y(2,1) NaN; TABLE_SEMIVARIANCE_Y(2,2) NaN; TABLE_SEMIVARIANCE_Y(2,[3,4])] ...
                                 [TABLE_SEMIVARIANCE_Y(2,5) NaN; TABLE_SEMIVARIANCE_Y(2,6) NaN; TABLE_SEMIVARIANCE_Y(2,[7,8])]]];
TABLE_SemiVolRatioGDP_toShow = round(TABLE_SemiVolRatioGDP_toShow,3);

TABLE_2 = TABLE_SemiVolRatioGDP_toShow; 
% swp2(TABLE_2,'Table_SemiVolRatio.tex');
